% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remoteComputing.R
\name{runbg_bwfor}
\alias{runbg_bwfor}
\title{Run an R expression on the bwForCluster}
\usage{
runbg_bwfor(..., machine, filename = NULL, nodes = 1, cores = 1,
  walltime = "01:00:00", input = ls(.GlobalEnv), compile = TRUE)
}
\arguments{
\item{...}{Some R code}

\item{machine}{e.g. \code{fr_dk846@bwfor.cluster.uni-mannheim.de}}

\item{filename}{Character, defining the filename of the temporary file. Random
file name ist chosen if NULL.}

\item{nodes}{Number of nodes, e.g. 10}

\item{cores}{Number of cores, e.g. 16}

\item{walltime}{estimated runtime in the format \code{hh:mm:ss}, e.g. \code{01:30:00}.
Jobs with a walltime up to 30 min are sent to a quick queue. When the walltime
is exceeded, all jobs are automatically killed by the queue.}

\item{input}{Character vector, the objects in the workspace that are stored
into an R data file and copied to the remove machine.}

\item{compile}{Logical. If \code{TRUE}, C files are copied and compiled on the remote machine.
Otherwise, the .so files are copied.}
}
\value{
List of functions \code{check()}, \code{get()} and \code{purge()}. 
\code{check()} checks, if the result is ready.
\code{get()} copies the result file
to the working directory and loads it into the workspace as an object called \code{.runbgOutput}. 
This object is a list named according to the machines that contains the results returned by each
machine.
\code{purge()} deletes the temporary folder
from the working directory and the remote machines.
}
\description{
Generate an R code of the expression that is copied via \code{scp}
to the bwForCluster (ssh-key needed). Then collect the results.
}
\details{
\code{runbg()} generates a workspace from the \code{input} argument
and copies the workspace and all C files or .so files to the remote machines via
\code{scp}. This will only work if *an ssh-key had been generated and added
to the authorized keys on the remote machine*. The
code snippet, i.e. the \code{...} argument, can include several intermediate results
but only the last call which is not redirected into a variable is returned via the
variable \code{.runbgOutput}, see example below.
}
\examples{
\dontrun{
out_job1 <- runbg({
   mstrust(obj, center, fits = 10, cores = 2)
 }, 
 machine = "bwfor", nodes = 2, cores = "2:best", 
 walltime = "00:01:00", 
 filename = "job1")
out_job1$check()          
out_job1$get()
out_job1$purge()
result <- .runbgOutput
print(result)
}

}

