% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{prdframe}
\alias{prdframe}
\title{Prediction frame}
\usage{
prdframe(prediction = NULL, deriv = NULL, sensitivities = NULL,
  parameters = NULL)
}
\arguments{
\item{prediction}{matrix of model prediction}

\item{deriv}{matrix of sensitivities wrt outer parameters}

\item{sensitivities}{matrix of sensitivitie wrt inner parameters}

\item{parameters}{names of the outer paramters}
}
\value{
Object of class \code{prdframe}, i.e. a matrix with other matrices and vectors as attributes.
}
\description{
A prediction frame is used to store a model prediction in a matrix. The columns
of the matrix are "time" and one column per state. The prediction frame has attributes "deriv",
the matrix of sensitivities with respect to "outer parameters" (see \link{P}), an attribute
"sensitivities", the matrix of sensitivities with respect to the "inner parameters" (the model
parameters, left-hand-side of the parameter transformation) and an attributes "parameters", the
parameter vector of inner parameters to produce the prediction frame.

Prediction frames are usually the constituents of prediction lists (\link{prdlist}). They are
produced by \link{Xs}, \link{Xd} or \link{Xf}. When you define your own prediction functions,
see \code{P2X} in \link{prdfn}, the result should be returned as a prediction frame.
}

