% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/prediction.R
\name{Y}
\alias{Y}
\title{Observation functions.}
\usage{
Y(g, f, compile = FALSE)
}
\arguments{
\item{g}{Named character vector defining the observation function}

\item{f}{Named character, the underlying ODE}

\item{compile}{Logical, compile the function (see \link{funC0})}
}
\value{
a function \code{y(out, pars, attach=FALSE)} representing the evaluation of the observation function.
If \code{out} has the attribute  "sensitivities", the result of
\code{y(out, pars)}, will have an attributed "deriv" which reflec the sensitivities of
the observation with respect to the parameters.
If \code{pars} is the result of a parameter transformation \code{p(pars)} (see \link{P}),
the Jacobian
of the parameter transformation and the sensitivities of the observation function
are multiplied according to the chain rule for differentiation.
If \code{attach = TRUE}, the original argument \code{out} will be attached to the evaluated observations.
}
\description{
Creates a function \code{y(out, pars)} that evaluates an observation function
and its derivatives based on the output of a model function \code{x(times, pars)}, see \link{Xf} and \link{Xs}.
}

