% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_threshold.R
\name{variance_threshold}
\alias{variance_threshold}
\title{Remove variables with near-zero variance.}
\usage{
variance_threshold(variables, sample)
}
\arguments{
\item{variables}{character vector specifying observation variables.}

\item{sample}{tbl containing sample used to estimate parameters.}
}
\value{
character vector specifying observation variables to be excluded.
}
\description{
\code{variance_threshold} returns list of variables that have near-zero variance.
}
\details{
\code{variance_threshold} is a reimplementation of \code{caret::nearZeroVar}, using
the default values for \code{freqCut} and \code{uniqueCut}.
}
\examples{
sample <- tibble::tibble(
  AreaShape_Area = c(10, 12, 15, 16, 8, 8, 7, 7, 13, 18),
  AreaShape_Euler = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
)
variables <- c("AreaShape_Area", "AreaShape_Euler")
variance_threshold(variables, sample)
}
