% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeStats.R
\name{computeStats}
\alias{computeStats}
\title{Compute CV statistics}
\usage{
computeStats(cvstuff, foldid, lambda, grouped)
}
\arguments{
\item{cvstuff}{Output from a call to `computeRawError()`.}

\item{foldid}{Vector of values identifying which fold each observation is
in.}

\item{lambda}{Lambda values associated with the errors in `cvstuff`.}

\item{grouped}{Experimental argument; see `kfoldcv()` documentation for
details.}
}
\value{
A list with the following elements:
\item{lambda}{The values of lambda used in the fits.}
\item{cvm}{The mean cross-validated error: a vector of length
`length(lambda)`.}
\item{cvsd}{Estimate of standard error of `cvm`.}
\item{cvup}{Upper curve = `cvm + cvsd`.}
\item{cvlo}{Lower curve = `cvm - cvsd`.}
}
\description{
Use the returned output from `computeRawError()` to compute CV statistics.
}
