% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{denseLinearShrinkEst}
\alias{denseLinearShrinkEst}
\title{Linear Shrinkage Estimator, Dense Target}
\usage{
denseLinearShrinkEst(dat)
}
\arguments{
\item{dat}{A numeric \code{data.frame}, \code{matrix}, or similar object.}
}
\value{
A \code{matrix} corresponding to the estimate of the covariance
matrix.
}
\description{
\code{denseLinearShrinkEst()} computes the asymptotically
optimal convex combination of the sample covariance matrix and a dense
target matrix. This target matrix's diagonal elements are equal to the
average of the sample covariance matrix estimate's diagonal elements, and
its off-diagonal elements are equal to the average of the sample covariance
matrix estimate's off-diagonal elements. For information on this
estimator's derivation, see \insertCite{Ledoit2020b;textual}{cvCovEst} and
\insertCite{shafer2005;textual}{cvCovEst}.
}
\examples{
denseLinearShrinkEst(dat = mtcars)
}
\references{
\insertAllCited{}
}
