% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fil.R
\name{cuml_fil_enabled}
\alias{cuml_fil_enabled}
\title{Determine whether Forest Inference Library (FIL) functionalities are enabled
in the current installation of {cuml}.}
\usage{
cuml_fil_enabled()
}
\value{
A logical value indicating whether the Forest Inference Library (FIL)
  functionalities are enabled.
}
\description{
CuML Forest Inference Library (FIL) functionalities (see
https://github.com/rapidsai/cuml/tree/main/python/cuml/fil#readme) will
require Treelite C API. If you need FIL to run tree-based model ensemble on
GPU, and \code{fil_enabled()} returns FALSE, then please consider installing
Treelite and then re-installing {cuml}.
}
\examples{
if (cuml_fil_enabled()) {
  # run GPU-accelerated Forest Inference Library (FIL) functionalities
} else {
  message(
    "FIL functionalities are disabled in the current installation of ",
    "{cuml}. Please reinstall Treelite C library first, and then re-install",
    " {cuml} to enable FIL."
  )
}
}
