\name{fmri_design}
\alias{fmri_design}
\docType{data}
\title{Example of design matrix for the real visual-auditory dataset}
\description{
  FMRI analysis requires the specification of the design matrix to be used in processing the general linear model. 
  The design matrix defines the experimental design and the nature of hypothesis testing to be implemented.
  The design matrix has one row for each scan and one column for each effect or explanatory variable (regressor or stimulus function). 
  The design matrix is used in fMRI analysis to specify the basis functions modeling the hemodynamic response function (HRF). It could be based on a single basis function or a set of functions.
  Two common basis function models are: (1) a single basis function is used for each explanatory variable; (2) a second time derivative basis functions is added to model (1), for each explanatory variable.
  The \file{fmri.nii.gz} dataset uses two explanatory variable, to take into account the  the auditory and the visual stimulations.
  The design matrix used in the example follows model (2) above, (4 regressors, excluding the intercept).
  \code{cudaMultireg.slice} includes an additional intercept variable for regression. 
  Therefore the explanatory variables of interest for brain visualization purposes in Posterior Probability Mapping (PPM) images are variables number 2 and 4. In the code they are referenced as \samp{vreg=2} and \samp{vreg=4}.
}
\usage{
  fbase <- "fmri"
  fsl.design <- system.file(paste("data/", fbase, "_design.txt", 
        sep = ""), package = "cudaBayesreg")
  dsgn <- read.table(fsl.design, hea = F)
}
\format{
  The file \file{fmri_design.txt} used is a data frame with 45 observations on the following 4 explanatory variables: auditory, auditory temporal derivative, visual, and visual temporal derivative. 
  The file  \file{fmri_design.txt} is based on the file \file{design.mat} generated by the FSL/FEAT tool. 
  Similar procedures for generating design matrices for fMRI datasets are available in the SPM toolbox (\url{http://www.fil.ion.ucl.ac.uk/spm/}).
}
\references{
 \emph{FSL & FreeSurfer Course}, Oxford Centre for Functional Magnetic Resonance Imaging of the Brain (FMRIB), University of Oxford.\cr
  (\url{www.fmrib.ox.ac.uk/fsl}).
}
\keyword{datasets}
