% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm.R
\name{cuda_ml_svm}
\alias{cuda_ml_svm}
\alias{cuda_ml_svm.default}
\alias{cuda_ml_svm.data.frame}
\alias{cuda_ml_svm.matrix}
\alias{cuda_ml_svm.formula}
\alias{cuda_ml_svm.recipe}
\title{Train a SVM model.}
\usage{
cuda_ml_svm(x, ...)

\method{cuda_ml_svm}{default}(x, ...)

\method{cuda_ml_svm}{data.frame}(
  x,
  y,
  cost = 1,
  kernel = c("rbf", "tanh", "polynomial", "linear"),
  gamma = NULL,
  coef0 = 0,
  degree = 3L,
  tol = 0.001,
  max_iter = NULL,
  nochange_steps = 1000L,
  cache_size = 1024,
  epsilon = 0.1,
  sample_weights = NULL,
  cuML_log_level = c("off", "critical", "error", "warn", "info", "debug", "trace"),
  ...
)

\method{cuda_ml_svm}{matrix}(
  x,
  y,
  cost = 1,
  kernel = c("rbf", "tanh", "polynomial", "linear"),
  gamma = NULL,
  coef0 = 0,
  degree = 3L,
  tol = 0.001,
  max_iter = NULL,
  nochange_steps = 1000L,
  cache_size = 1024,
  epsilon = 0.1,
  sample_weights = NULL,
  cuML_log_level = c("off", "critical", "error", "warn", "info", "debug", "trace"),
  ...
)

\method{cuda_ml_svm}{formula}(
  formula,
  data,
  cost = 1,
  kernel = c("rbf", "tanh", "polynomial", "linear"),
  gamma = NULL,
  coef0 = 0,
  degree = 3L,
  tol = 0.001,
  max_iter = NULL,
  nochange_steps = 1000L,
  cache_size = 1024,
  epsilon = 0.1,
  sample_weights = NULL,
  cuML_log_level = c("off", "critical", "error", "warn", "info", "debug", "trace"),
  ...
)

\method{cuda_ml_svm}{recipe}(
  x,
  data,
  cost = 1,
  kernel = c("rbf", "tanh", "polynomial", "linear"),
  gamma = NULL,
  coef0 = 0,
  degree = 3L,
  tol = 0.001,
  max_iter = NULL,
  nochange_steps = 1000L,
  cache_size = 1024,
  epsilon = 0.1,
  sample_weights = NULL,
  cuML_log_level = c("off", "critical", "error", "warn", "info", "debug", "trace"),
  ...
)
}
\arguments{
\item{x}{Depending on the context:

  * A __data frame__ of predictors.
  * A __matrix__ of predictors.
  * A __recipe__ specifying a set of preprocessing steps
  * created from [recipes::recipe()].
  * A __formula__ specifying the predictors and the outcome.}

\item{...}{Optional arguments; currently unused.}

\item{y}{A numeric vector (for regression) or factor (for classification) of
desired responses.}

\item{cost}{A positive number for the cost of predicting a sample within or
on the wrong side of the margin. Default: 1.}

\item{kernel}{Type of the SVM kernel function (must be one of "rbf", "tanh",
"polynomial", or "linear"). Default: "rbf".}

\item{gamma}{The gamma coefficient (only relevant to polynomial, RBF, and
  tanh kernel functions, see explanations below).
  Default: 1 / (num features).

  The following kernels are implemented:
    - RBF K(x_1, x_2) = exp(-gamma |x_1-x_2|^2)
    - TANH K(x_1, x_2) = tanh(gamma <x_1,x_2> + coef0)
    - POLYNOMIAL K(x_1, x_2) = (gamma <x_1,x_2> + coef0)^degree
    - LINEAR K(x_1,x_2) = <x_1,x_2>,
  where < , > denotes the dot product.}

\item{coef0}{The 0th coefficient (only applicable to polynomial and tanh
  kernel functions, see explanations below). Default: 0.

  The following kernels are implemented:
    - RBF K(x_1, x_2) = exp(-gamma |x_1-x_2|^2)
    - TANH K(x_1, x_2) = tanh(gamma <x_1,x_2> + coef0)
    - POLYNOMIAL K(x_1, x_2) = (gamma <x_1,x_2> + coef0)^degree
    - LINEAR K(x_1,x_2) = <x_1,x_2>,
  where < , > denotes the dot product.}

\item{degree}{Degree of the polynomial kernel function (note: not applicable
  to other kernel types, see explanations below). Default: 3.

  The following kernels are implemented:
    - RBF K(x_1, x_2) = exp(-gamma |x_1-x_2|^2)
    - TANH K(x_1, x_2) = tanh(gamma <x_1,x_2> + coef0)
    - POLYNOMIAL K(x_1, x_2) = (gamma <x_1,x_2> + coef0)^degree
    - LINEAR K(x_1,x_2) = <x_1,x_2>,
  where < , > denotes the dot product.}

\item{tol}{Tolerance to stop fitting. Default: 1e-3.}

\item{max_iter}{Maximum number of outer iterations in SmoSolver.
Default: 100 * (num samples).}

\item{nochange_steps}{Number of steps with no change w.r.t convergence.
Default: 1000.}

\item{cache_size}{Size of kernel cache (MiB) in device memory. Default: 1024.}

\item{epsilon}{Espsilon parameter of the epsilon-SVR model. There is no
penalty for points that are predicted within the epsilon-tube around the
target values. Please note this parameter is only relevant for regression
tasks. Default: 0.1.}

\item{sample_weights}{Optional weight assigned to each input data point.}

\item{cuML_log_level}{Log level within cuML library functions. Must be one of
{"off", "critical", "error", "warn", "info", "debug", "trace"}.
Default: off.}

\item{formula}{A formula specifying the outcome terms on the left-hand side,
and the predictor terms on the right-hand side.}

\item{data}{When a __recipe__ or __formula__ is used, \code{data} is
specified as a  __data frame__ containing the predictors and (if
applicable) the outcome.}
}
\value{
A SVM classifier / regressor object that can be used with the
  'predict' S3 generic to make predictions on new data points.
}
\description{
Train a Support Vector Machine model for classification or regression tasks.
}
\examples{

library(cuda.ml)

# Classification

model <- cuda_ml_svm(
  formula = Species ~ .,
  data = iris,
  kernel = "rbf"
)

predictions <- predict(model, iris[names(iris) != "Species"])

# Regression

model <- cuda_ml_svm(
  formula = mpg ~ .,
  data = mtcars,
  kernel = "rbf"
)

predictions <- predict(model, mtcars)
}
