% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\encoding{UTF-8}
\name{entropy}
\alias{entropy}
\title{Computes the entropy of a categorical time series}
\usage{
entropy(series, categories, features = FALSE)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{features}{Logical. If \code{features = FALSE} (default), the value of the entropy is returned. Otherwise, the function
returns a vector with the individual components of the entropy.}
}
\value{
The value of the entropy.
}
\description{
\code{entropy} returns the value of the entropy for
a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated entropy, \eqn{\widehat{e}=\frac{-1}{\ln(r)}\sum_{i=1}^{r}\widehat{p}_i\ln \widehat{p}_i},
where \eqn{\widehat{p}_i} is the natural estimate of the marginal probability of the \eqn{i}th
category, \eqn{i=1, \ldots, r}. If \code{features = TRUE}, the function
returns a vector whose components are the quantities \eqn{\widehat{p}_i\ln(\widehat{p}_i)},
\eqn{i=1,2, \ldots,r}.
}
\examples{
et <- entropy(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the entropy
# for the first series in dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
