% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ctStanFit.R
\name{ctStanSubjectPars}
\alias{ctStanSubjectPars}
\title{Extract an array of subject specific parameters from a ctStanFit object.}
\usage{
ctStanSubjectPars(fit, pointest = TRUE, cores = 2, nsamples = "all")
}
\arguments{
\item{fit}{fit object}

\item{pointest}{if TRUE, returns only the set of individual difference parameters
based on the max a posteriori estimate (or the median if sampling approaches were used).}

\item{cores}{Number of cores to use.}

\item{nsamples}{Number of samples to calculate parameters for. Not used if pointest=TRUE.}
}
\value{
an nsamples by nsubjects by nparams array.
}
\description{
Extract an array of subject specific parameters from a ctStanFit object.
}
\details{
This function returns the estimates of individual parameters, taking into account any
covariates and random effects.
}
\examples{
indpars <- ctStanSubjectPars(ctstantestfit)
dimnames(indpars)
plot(indpars[1,,'cint1'],indpars[1,,'cint2'])
}
