% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDiscretePars.R
\name{ctStanDiscretePars}
\alias{ctStanDiscretePars}
\title{ctStanDiscretePars}
\usage{
ctStanDiscretePars(ctstanfitobj, subjects = "all", times = seq(from =
  0, to = 10, by = 0.1), quantiles = c(0.025, 0.5, 0.975),
  nsamples = 500, plot = FALSE, ...)
}
\arguments{
\item{ctstanfitobj}{Continuous time model fit from \code{\link{ctStanFit}}}

\item{subjects}{Either 'all', to take the average over all subjects, or a vector of integers denoting which
subjects.}

\item{times}{Numeric vector of positive values, discrete time parameters will be calculated for each.}

\item{quantiles}{Which quantiles to return. If plotting, specify 3 quantiles, 
the 2nd will be plotted as a line with 1 and 3 as uncertainty bounds.}

\item{nsamples}{Number of samples from the stanfit to use for plotting. Higher values will
increase smoothness / accuracy, at cost of plotting speed. Values greater than the total
number of samples will be set to total samples.}

\item{plot}{Logical. If TRUE, plots output using \code{\link{ctStanDiscreteParsPlot}}
instead of returning output.}

\item{...}{additional plotting arguments to control \code{\link{ctStanDiscreteParsPlot}}}
}
\description{
Calculate model implied regressions for a sequence of time intervals based on a continuous time model fit
from ctStanFit, for specified subjects.
}
\examples{
ctStanDiscretePars(ctstantestfit,times=seq(.5,4,.1), 
 plot=TRUE,indices='all')
}
