% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda.ct.R
\name{lda.ct}
\alias{lda.ct}
\title{Continuous-time Fisher's linear discriminant analysis}
\usage{
lda.ct(fdobj, partition, part.names = NULL)
}
\arguments{
\item{fdobj}{continuous-time multivariate data set of class \code{"\link[fda]{fd}"}}

\item{partition}{a priori break points dividing the time interval into segments}

\item{part.names}{optional character vector of names for the segments}
}
\value{
Object of class "\code{lda.ct}", a list consisting of
\item{means }{means of the variables within each segment}
\item{scaling }{matrix of coefficients defining the discriminants (as in \code{\link[MASS]{lda}})}
\item{values }{eigenvalues giving the ratios of between to within sums of squares}
\item{partition }{the supplied \code{partition}}
\item{fdobj }{linear discriminants represented as an \code{"\link[fda]{fd}"} object}
\item{nld }{number of linear discriminants}
}
\description{
A continuous-time version of Fisher's LDA, in which segments of the time
interval take the place of groups of observations.
}
\details{
The \code{means} and \code{scaling} components of the output are similar to
\code{\link[MASS]{lda}}, but unlike that function, \code{lda.ct} performs only
\emph{Fisher's} LDA and cannot incorporate priors or perform classification.
}
\examples{

## see end of example in ?pca.ct

}
\seealso{
\code{\link{plot.lda.ct}}; \code{\link[MASS]{lda}}, for the classical version
}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
