% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cites.R
\name{get_cites}
\alias{get_cites}
\title{Get citations for CSPP variables}
\usage{
get_cites(
  var_names,
  write_out = FALSE,
  file_path = NULL,
  format = "bib",
  print_cites = FALSE,
  print_nomatch = TRUE
)
}
\arguments{
\item{var_names}{Default is NULL. Takes a character string. Should be one
or more variables from the CSPP dataset. A citation for each variable
is returned.}

\item{write_out}{Default is FALSE. Takes a logical. If FALSE the function
does not write the citations out to a file.}

\item{file_path}{Default is NULL. Takes a character string. If \code{write_out = T}
then the file will be saved to this filepath.}

\item{format}{Default is bib. Takes a character string. If \code{write_out = T} then
the resulting file will be in this format. User must supply "bib", "csv", or "txt".}

\item{print_cites}{Default is FALSE. Takes a logical value. If TRUE then the
function prints the citations to the console.}

\item{print_nomatch}{Default is TRUE. Takes a logical value. If FALSE then
the function does not print variables the user supplied that had no match
in CSPP.}
}
\description{
\code{get_cites} retrieves citations for variables in the CSPP dataset. Users
can print the citations to the console, save them as dataframes, and write
them to multiple file types (csv, txt). Citations can be written in one of
multiple formats (plaintext, bib). Supply variable names that need to be
cited with the \code{var_names} argument. The function prints user-supplied
variable names that do not match any in the CSPP dataset by default (\code{print_nomatch}).
The function also returns the citation for the \code{cspp} package and the
CSPP dataset as a whole. We request you cite both if you use this package
for your research.
}
\examples{

get_cites("poptotal")

\dontrun{
get_cites(var_names = "poptotal",
          write_out = TRUE,
          file_path = "~/path/to/file.csv",
          format = "csv")
}
}
\seealso{
\code{\link{get_cspp_data}}, \code{\link{get_var_info}}, \code{\link{generate_map}}
}
