import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.GMLWriter;
import com.vividsolutions.jump.io.ShapefileReader;
import com.vividsolutions.jump.io.ShapefileWriter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;

/**
 * Code to test the polygon simplification
 * Nils B. Weidmann (nils.weidmann@gmail.com)
 */
public class CShapesTools {

    private FeatureCollection fc;
    private String packageHome = "/Users/nilsw/Projects/CShapes/R-Forge/pkg/inst/shp";

    public void simplify() {

        // read the shapefile
		fc = null;
		try {
			File file = new File(packageHome, "cshapes.shp");
			DriverProperties dp = new DriverProperties(file.getAbsolutePath());
			fc = (new ShapefileReader()).read(dp);
		} catch (Exception e) {
			e.printStackTrace();
		}

        FeatureCollection fcnew = new FeatureDataset(fc.getFeatureSchema());
		Iterator it = fc.iterator();

        while (it.hasNext()) {

            Feature f = (Feature) it.next();
            Geometry simpleGeometry = TopologyPreservingSimplifier.simplify(f.getGeometry(), 0.1);
            f.setGeometry(simpleGeometry);
            fcnew.add(f);
        }

        try {
			File file = new File(packageHome, "cshapes_simple.shp");
			DriverProperties dp = new DriverProperties(file.getAbsolutePath());
			(new ShapefileWriter()).write(fcnew, dp);
		} catch (Exception e) {
			e.printStackTrace();
		}
    }

    public void exportKML(boolean useGW) {

        String ctrcode, syear, smonth, sday, eyear, emonth, eday;

        if (!useGW) {
            ctrcode = "COWCODE";
            syear = "COWSYEAR";
            smonth = "COWSMONTH";
            sday = "COWSDAY";
            eyear = "COWEYEAR";
            emonth = "COWEMONTH";
            eday = "COWEDAY";
        }
        else {
            ctrcode = "GWCODE";
            syear = "GWSYEAR";
            smonth = "GWSMONTH";
            sday = "GWSDAY";
            eyear = "GWEYEAR";
            emonth = "GWEMONTH";
            eday = "GWEDAY";
        }

        FeatureCollection fc = null;
        try {
            File file = new File(packageHome, "shp/cshapes.shp");
            DriverProperties dp = new DriverProperties(file.getAbsolutePath());
            fc = (new ShapefileReader()).read(dp);
        } catch (Exception e) {
            e.printStackTrace();
        }

        // open output file, write header
        try {
            FileWriter out = new FileWriter(new File("cshapes.kml"));
            out.write(header+ "\n");
            out.write(style + "\n");



            Iterator it = fc.iterator();
            while (it.hasNext()) {
                Feature f = (Feature) it.next();

                int startyear = ((Number) f.getAttribute(syear)).intValue();
                int startmonth = ((Number) f.getAttribute(smonth)).intValue();
                int startday = ((Number) f.getAttribute(sday)).intValue();

                int endyear = ((Number) f.getAttribute(eyear)).intValue();
                int endmonth = ((Number) f.getAttribute(emonth)).intValue();
                int endday = ((Number) f.getAttribute(eday)).intValue();

                GregorianCalendar startdate
                        = new GregorianCalendar(startyear, startmonth, startday);
                GregorianCalendar enddate
                        = new GregorianCalendar(endyear, endmonth, endday);

                out.write("<Placemark>\n");
                //out.write("<name>" + Id + "</name>" + "\n");
                out.write("<TimeStamp><when>" + startdate.toString() + "</when></TimeStamp>" + "\n");
                out.write("<styleUrl>#testEventStyle</styleUrl>" + "\n");
                //out.write((new GMLWriter).write(f.getGeometry(), null) + "\n");
                out.write("</Placemark>\n");

            }

            out.write(footer+ "\n");
            out.close();

        } catch (
                IOException e) {
            e.printStackTrace();
        }
    }


    public static void main(String[] args) {
        CShapesTools s = new CShapesTools();
        s.simplify();
    }

    private static String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n" +
                "<Document>";
    private static String footer = "</Document>\n</kml>";
    private static String style = "" +
            "<Style id=\"testEventStyle\">\n" +
            "      <IconStyle>\n" +
            "        <Icon><href>http://maps.google.com/mapfiles/kml/pal4/icon24.png</href></Icon>\n" +
            "      </IconStyle>\n" +
            "</Style>";

}
