% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_CDC_exchange_rewards.R
\name{format_CDC_exchange_rewards}
\alias{format_CDC_exchange_rewards}
\title{Format CDC exchange file (FOR REWARDS ONLY)}
\usage{
format_CDC_exchange_rewards(data, list.prices = NULL, force = FALSE)
}
\arguments{
\item{data}{The dataframe}

\item{list.prices}{A \code{list.prices} object from which to fetch coin prices.}

\item{force}{Whether to force recreating \code{list.prices} even though
it already exists (e.g., if you added new coins or new dates).}
}
\value{
A data frame of exchange transactions, formatted for further processing.
}
\description{
Format a .csv transaction history file from the
Crypto.com exchange for later ACB processing. Only processes
rewards and withdrawal fees, not trades (see
\code{format_CDC_exchange_trades} for this).

To download the rewards/withdrawal fees data from the Crypto.com
exchange as a CSV file, copy and paste the code below and save it
as a bookmark in your browser.

\verb{javascript:(function()\{function callback()\{window.cdc()\}var s=document.createElement("script");s.src="https://cdn.jsdelivr.net/gh/ConorIA/cdc-csv@master/cdc.js";if(s.addEventListener)\{s.addEventListener("load",callback,false)\}else if(s.readyState)\{s.onreadystatechange=callback\}document.body.appendChild(s);\})()}

Then log into the crypto.com exchange and click the bookmark you
saved. It will automatically download a CSV that contains Supercharger
rewards, withdrawal fees, CRO staking interest (if you have an
exchange stake), among others.

Note that this code does not include the initial referral reward in CRO
for signup or on the Crypto.com exchange. It must be added manually.

WARNING: DOES NOT DOWNLOAD TRADES, ONLY REWARDS, ONLY REWARDS AND WITHDRAWALS!
}
\examples{
format_CDC_exchange_rewards(data_CDC_exchange_rewards)
}
