% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax_box.R
\name{tax_box}
\alias{tax_box}
\title{Get a simple table of relevant tax information}
\usage{
tax_box(report.summary, sup.losses, table.revenues, proceeds)
}
\arguments{
\item{report.summary}{report.summary}

\item{sup.losses}{sup.losses}

\item{table.revenues}{table.revenues}

\item{proceeds}{proceeds}
}
\value{
A data frame, with the following columns: Description, Amount,
Comment, Line
}
\description{
Output a simple table with all the relevant tax information and tax form line numbers.
}
\examples{
my.list.prices <- prepare_list_prices(coins = "BTC", start.date = "2021-01-01")
all.data <- format_shakepay(data_shakepay)
formatted.ACB <- format_ACB(all.data, verbose = FALSE)
report.summary <- report_summary(formatted.ACB, today.data = TRUE, list.prices = my.list.prices)
sup.losses <- get_sup_losses(formatted.ACB, 2021)
table.revenues <- report_revenues(formatted.ACB, 2021)
proceeds <- get_proceeds(formatted.ACB, 2021)
tax_box(report.summary, sup.losses, table.revenues, proceeds)
}
