% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_macd.R
\name{macd}
\alias{macd}
\title{Chart the Moving Average Convergence Divergence (MACD) indicator}
\usage{
macd(
 nFast   = 12,
 nSlow   = 26,
 nSig    = 9,
 maType  = "SMA",
 percent = TRUE,
 ...
)
}
\arguments{
\item{nFast}{Number of periods for fast moving average.}

\item{nSlow}{Number of periods for slow moving average.}

\item{nSig}{Number of periods for signal moving average.}

\item{maType}{Either:
\enumerate{
  \item A function or a string naming the function to be called.
  \item A \emph{list} with the first component like (1) above, and
    additional parameters specified as \emph{named} components.
    See Examples.
}}

\item{percent}{logical; if \code{TRUE}, the percentage difference between the
fast and slow moving averages is returned, otherwise the difference between
the respective averages is returned.}

\item{...}{For internal use. Please ignore.}
}
\value{
An \link{invisible} \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:plot_ly]{plotly::plot_ly()}}- and \code{\link[plotly:add_trace]{plotly::add_lines()}}-function that
interacts with the \code{\link[TTR:MACD]{TTR::MACD()}}-function. The function adds subchart with a
\code{\link[TTR:MACD]{TTR::MACD()}}-indicator.
}
\examples{
# script start;

# 1) charting weekly
# BTC using candlesticks
# and indicators
cryptoQuotes::chart(
  ticker     = BTC,
  main       = cryptoQuotes::kline(),
  sub        = list(
    cryptoQuotes::volume(),
    cryptoQuotes::macd()
  ),
  indicator = list(
    cryptoQuotes::bollinger_bands(),
    cryptoQuotes::sma(),
    cryptoQuotes::alma()
  ),
  options = list(
    dark       = TRUE,
    deficiency = FALSE
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other subchart indicators: 
\code{\link{add_event}()},
\code{\link{fgi}()},
\code{\link{lsr}()},
\code{\link{rsi}()},
\code{\link{smi}()},
\code{\link{volume}()}

Other momentum indicators: 
\code{\link{rsi}()},
\code{\link{smi}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{momentum indicators}
\concept{subchart indicators}
