% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_ma.R
\name{evwma}
\alias{evwma}
\title{Add Elastic Volume-weighted Moving Average to the chart}
\usage{
evwma(price = "Close", n = 10, internal = list(), ...)
}
\arguments{
\item{price}{A \link{character}-vector of \link{length} 1. Close by default. The name of the vector to passed into \link[TTR:MovingAverages]{TTR::EVWMA}}

\item{n}{Number of periods to average over. Must be between 1 and
\code{nrow(x)}, inclusive.}

\item{internal}{An empty \link{list}. Used for internal purposes. Ignore.}

\item{...}{any other passthrough parameters}
}
\value{
A \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object wrapped in \code{\link[rlang:expr]{rlang::expr()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:add_trace]{plotly::add_lines()}}-wrapper function that interacts with \link{TTR}'s moving average family of functions.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

## charting the klines
## with indicators as
## subcharts
chart(
  ticker     = BTC,
  main       = kline(),
  sub        = list(
    volume(),
    macd()
  ),
  indicator = list(
    bollinger_bands(),
    sma(),
    alma()
  ),
  options = list(
    dark = TRUE,
    deficiency = FALSE
  )
)

## charting the MACD-indicator
## with klines as subcharts
chart(
  ticker     = BTC,
  main       = macd(),
  sub        = list(
    volume(),
    kline()
  ),
  indicator = list(
    bollinger_bands(),
    sma()
  ),
  options = list(
    dark = TRUE,
    deficiency = FALSE
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other moving average indicators: 
\code{\link{alma}()},
\code{\link{dema}()},
\code{\link{ema}()},
\code{\link{hma}()},
\code{\link{sma}()},
\code{\link{wma}()},
\code{\link{zlema}()}
}
\concept{chart indicators}
\concept{moving average indicators}
