% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_indicators.R
\name{addBBands}
\alias{addBBands}
\title{Add Bollinger Bands
to the chart}
\usage{
addBBands(chart, cols = c("High", "Low", "Close"), ...)
}
\arguments{
\item{chart}{a \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} chart}

\item{cols}{a vector of column names used to calculate the  Bollinger Bands
Default values \code{High}, \code{Low} and \code{Close}}

\item{...}{See \code{\link[TTR:bollingerBands]{TTR::BBands()}}}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Bollinger Bands provide a visual representation of price volatility and are widely used by traders
and investors to assess potential price reversals and trade opportunities in various financial markets, including stocks, forex, and commodities.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

# library
library(cryptoQuotes)

# charting klines
# with various indicators
chart(
  chart = kline(
    ATOMUSDT
  ) \%>\% addVolume() \%>\% addMA(
    FUN = TTR::SMA,
    n = 7
  ) \%>\% addMA(
    FUN = TTR::SMA,
    n = 14
  ) \%>\%
    addBBands() \%>\%
    addMACD() \%>\%
    addRSI()

)


# script end;
}
\seealso{
Other chart indicators: 
\code{\link{addEvents}()},
\code{\link{addFGIndex}()},
\code{\link{addLSRatio}()},
\code{\link{addMACD}()},
\code{\link{addMA}()},
\code{\link{addRSI}()},
\code{\link{addVolume}()},
\code{\link{chart}()}
}
\concept{chart indicators}
