% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLSRatio.R
\name{getLSRatio}
\alias{getLSRatio}
\title{Get long-short ratios for tickers}
\usage{
getLSRatio(ticker, interval = "1d", top = FALSE, from = NULL, to = NULL)
}
\arguments{
\item{ticker}{A character vector of length 1. Uppercase. See \code{\link[=availableTickers]{availableTickers()}} for available tickers.}

\item{interval}{A character vector of length 1. See \code{\link[=availableIntervals]{availableIntervals()}} for available intervals.}

\item{top}{A logical vector. \link{FALSE} by default. If \link{TRUE} it returns the top traders Long-Short ratios.}

\item{from}{An optional vector of length 1. Can be \code{\link[=Sys.Date]{Sys.Date()}}-class, \code{\link[=Sys.time]{Sys.time()}}-class or \code{\link[=as.character]{as.character()}} in \%Y-\%m-\%d format.}

\item{to}{An optional vector of length 1. Can be \code{\link[=Sys.Date]{Sys.Date()}}-class, \code{\link[=Sys.time]{Sys.time()}}-class or \code{\link[=as.character]{as.character()}} in \%Y-\%m-\%d format.}
}
\value{
A xts object with the share of long and short position, and the ratio of the two. If no from and to are supplied
the 100 most recent pips are returned.
}
\description{
The long-short ratio is a market sentiment indicator on expected price movement
}
\details{
Note! This endpoint only supports intervals between 5 minutes and 1 day.
}
\examples{
# Example on loading
# long-short ratio
# for the last days
# on the 15 minute candle
# wrapped in try to avoid
# failure on Github

# 1) long-short ratio
# on BTCUSDT pair
BTC_LSR <- try(
  expr = cryptoQuotes::getLSRatio(
    ticker = 'BTCUSDT',
    interval = '15m',
    from = Sys.Date() - 1,
    to   = Sys.Date()
  ),
  silent = TRUE
)

# 2) BTCSDT in same period
# as the long-short ratio;
BTCUSDT <- try(
  cryptoQuotes::getQuote(
    ticker = 'BTCUSDT',
    futures = TRUE,
    interval = '15m',
    from = Sys.Date() - 1,
    to   = Sys.Date()
  )
)

if (!inherits(x = BTC_LSR, what = 'try-error') & !inherits(x = BTCUSDT, what = "try-error")) {

  # 3) head the data
  # and display contents
  head(
    BTC_LSR
  )

  # 4) plot BTCUSDT-pair
  # with long-short ratio
  cryptoQuotes::chart(
    chart = cryptoQuotes::kline(
      BTCUSDT
    ) \%>\% cryptoQuotes::addLSRatio(
      LSR = BTC_LSR
    )
  )

}

# end of scrtipt;
}
\seealso{
Other sentiment: 
\code{\link{getFGIndex}()}
}
\author{
Jonas Cuzulan Hirani
}
\concept{sentiment}
