% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{pollProgress}
\alias{pollProgress}
\title{Check a Crunch progress URL until it finishes}
\usage{
pollProgress(progress_url, wait = 0.5, error_handler = NULL)
}
\arguments{
\item{progress_url}{A Crunch progress URL}

\item{wait}{Number of seconds to wait between polling. This time is increased
20 percent on each poll.}

\item{error_handler}{An optional function that takes the status object
when the progress is less than 0 (meaning the request failed)}
}
\value{
The percent completed of the progress. Assuming the
\code{options(crunch.timeout)} (default: 15 minutes) hasn't been reached, this
will be 100. If the timeout is reached, it will be the last reported progress
value.
}
\description{
You'll probably only call this function if progress polling times out and its
error message tells you to call \code{pollProgress} to resume.
}
