% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllGenerics.R,
%   R/subtotals-and-headings.R
\docType{class}
\name{Subtotal-class}
\alias{Subtotal-class}
\alias{Subtotal}
\alias{Heading-class}
\alias{Heading}
\alias{subtotals}
\alias{subtotals<-}
\alias{SubtotalsHeadings}
\alias{is.Subtotal}
\alias{is.Heading}
\alias{are.Subtotals}
\alias{are.Headings}
\alias{subtotals,CrunchVariable-method}
\alias{subtotals,VariableTuple-method}
\alias{subtotals<-,CrunchVariable,ANY-method}
\alias{subtotals<-,CrunchVariable,NULL-method}
\title{Subtotals and headings}
\usage{
Subtotal(
  name,
  categories,
  position = c("relative", "top", "bottom"),
  after = NULL
)

Heading(name, position = c("relative", "top", "bottom"), after = NULL)

subtotals(x)

subtotals(x) <- value

Subtotal(
  name,
  categories,
  position = c("relative", "top", "bottom"),
  after = NULL
)

is.Subtotal(x)

is.Heading(x)

are.Subtotals(x)

are.Headings(x)

Heading(name, position = c("relative", "top", "bottom"), after = NULL)

\S4method{subtotals}{CrunchVariable}(x)

\S4method{subtotals}{VariableTuple}(x)

\S4method{subtotals}{CrunchVariable,ANY}(x) <- value

\S4method{subtotals}{CrunchVariable,`NULL`}(x) <- value
}
\arguments{
\item{name}{character the name of the subtotal or heading}

\item{categories}{character or numeric the category names or ids for subtotal
only}

\item{position}{character one of "relative", "top", or "bottom". Determines
the position of the subtotal or heading, either at the top, bottom, or
relative to another category in the cube (default).}

\item{after}{character or numeric if \code{position} is "relative", then the
category name or id to position the subtotal or heading after. If not supplied
this defaults to the last of the \code{categories} supplied to \code{Subtotal}.}

\item{x}{either a variable or CrunchCube object to add or get subtotal
transforms for, for \code{is.Subtotal()} and \code{is.Heading()} an object to test if
it is either a Subtotal or Heading}

\item{value}{For \verb{[<-}, the replacement Subtotal to insert}
}
\description{
Subtotals and headings for categorical Variables and
CrunchCubes. These are especially useful for making aggregates across
multiple categories (sometimes referred to as \emph{nets}, \emph{top box}, or
\emph{top 2 box}).
}
\details{
To see the subtotals or headings set for a variable, use \code{subtotals(variable)}
}
\section{Adding Subtotals and Headings}{

Subtotals and headings can be added either by passing a list of \code{Subtotal}s
or \code{Heading}s, or they can be added one at a time by passing \code{Subtotal} or
\code{Heading} to \code{subtotals(variable)} alone.

Adding subtotals or headings is additive; meaning that subtotals or headings
that are already set on the variable are not removed when new subtotals or
headings are added. To remove all subtotals and headings, set
\code{subtotals(variable)} to \code{NULL}.

To get an array of just the subtotal rows from a CrunchCube, use the function
\code{subtotalArray(CrunchCube)}.
}

\section{Working with Subtotals and headings}{

When interacting programmatically with Subtotals and Headings, it can be
useful to be able to tell if something is a Subtotal or a Heading. The \verb{is.*}
family of methods are useful here: the singular versions (\code{is.Subtotal} and
\code{is.Heading}) take a single object and returns \code{TRUE} if the object is either
a Subtotal or a Heading and \code{FALSE} if not; the plural versions
(\code{are.Subtotals} and \code{are.Headings}) take a list of objects (including an
\code{Insertions} object) and returns a vector of \code{TRUE}/\code{FALSE}s.
}

\section{Removing transforms}{

\code{noTransforms()} is useful if you don't want to see or use any transformations like
Subtotals and Headings. This action only applies to the CrunchCube object in
R: it doesn't actually change the variables on Crunch servers or the query
that generated the CrunchCube.
}

\examples{
\dontrun{
# given a variable ds$opinion, with categories: Strongly Agree, Somewhat
# Agree, Neither Agree nor Disagree, Somewhat Disagree, and Strongly Disagree,
# to make two subtotals for Agree and Disagree:
subtotals(ds$opinion) <- list(
    Subtotal(
        name = "Agree",
        categories = c("Strongly Agree", "Somewhat Agree"),
        after = "Somewhat Agree"
    ),
    Subtotal(
        name = "Disagree",
        categories = c("Strongly Disagree", "Somewhat Disagree"),
        after = "Strongly Disagree"
    )
)

# headings can also be added:
subtotals(ds$opinion) <- Heading(name = "All opinions", position = "top")

# to see the subtotals and headings associated with a variable
subtotals(ds$opinion)
#        anchor         name     func    args
# 1      2        Agree subtotal 1 and 2
# 2      4     Disagree subtotal 4 and 5
# 3      0 All opinions     <NA>      NA

# when you use a variable with subtotals and headings in a cube, you see them
# by default
opinion_cube <- crtabs(~opinion, ds)
opinion_cube
#               All opinions
#             Strongly Agree 23
#             Somewhat Agree 24
#                      Agree 47
# Neither Agree nor Disagree 18
#          Somewhat Disagree 16
#          Strongly Disagree 19
#                   Disagree 35


# to get just the subtotals,
subtotalArray(opinion_cube)
#    Agree Disagree
#       47       35

# to remove all subtotals and headings
subtotals(ds$opinion) <- NULL
crtabs(~opinion, ds)
#             Strongly Agree 23
#             Somewhat Agree 24
# Neither Agree nor Disagree 18
#          Somewhat Disagree 16
#          Strongly Disagree 19

# if you want to temporarily remove subtotals and headings, you can with `noTransforms`
noTransforms(crtabs(~opinion, ds))
#             Strongly Agree             Somewhat Agree Neither Agree nor Disagree
#                         23                         24                         18
#          Somewhat Disagree          Strongly Disagree
#                         16                         19
}

}
