% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/cube-transforms.R,
%   R/transform.R
\docType{class}
\name{Transforms-class}
\alias{Transforms-class}
\alias{Transforms}
\alias{transforms,CrunchCube-method}
\alias{transforms,VariableCatalog-method}
\alias{transforms<-,CrunchCube,list-method}
\alias{transforms<-,CrunchCube,NULL-method}
\alias{Transforms}
\alias{transforms}
\alias{transforms<-}
\alias{transforms,CrunchVariable-method}
\alias{transforms,VariableTuple-method}
\alias{transforms<-,CrunchVariable,Transforms-method}
\alias{transforms<-,CrunchVariable,NULL-method}
\title{Transformations of variable and cube views}
\usage{
Transforms(..., data = NULL)

\S4method{transforms}{CrunchCube}(x)

\S4method{transforms}{VariableCatalog}(x)

\S4method{transforms}{CrunchCube,list}(x) <- value

\S4method{transforms}{CrunchCube,`NULL`}(x) <- value

\S4method{transforms}{CrunchVariable}(x)

\S4method{transforms}{VariableTuple}(x)

\S4method{transforms}{CrunchVariable,Transforms}(x) <- value

\S4method{transforms}{CrunchVariable,`NULL`}(x) <- value
}
\arguments{
\item{...}{For the constructor function \code{Transforms} you can pass
in attributes via \code{...}}

\item{data}{For the constructor function \code{Transforms} you can either pass in
attributes via \code{...} or you can create the objects with a fully defined
\code{list} representation of the objects via the \code{data} argument. See the examples.}

\item{x}{For the attribute getters and setters, an object of class
Transforms}

\item{value}{For \code{[<-}, the replacement Transforms to insert}
}
\description{
Transformations allow you to change how a variable or cube is displayed
without changing the underlying data.
}
\section{Getting transformations}{

The \code{transforms(x)} methods can be used with Variables and CrunchCubes to get
what transformations are currently set. For variables, they return a single
\code{Transforms} object that includes all transformations for the variable. For
CrunchCubes, it returns a named list with the same length as the number of
dimensions of the cube with each dimension's transformations.

Currently, \link{Insertions} (e.g. \link[=SubtotalsHeadings]{Subtotal()} and
\link[=SubtotalsHeadings]{Heading()}) are the only type of transformations that are
supported.
}

\section{Setting transformations on a variable}{

The \code{transforms(x) <- value} methods can be used to assign transformations
for a specific variable. \code{value}
must be a \code{Transforms} object. This allows you to set transformations on
categorical variables. These transformations will automatically show up in
any new CrunchCubes that contain this variable.
}

\section{Setting transformations on a CrunchCube}{

The \code{transforms(x) <- value} methods can also be used to assign
transformations to a CrunchCube that has already been calculated. \code{value}
must be a named list of \code{Transforms} objects. The names of this list must
correspond to dimensions in the cube (those dimensions correspondences are
matched based on variable aliases). You don't have to provide an entry for
each dimension, but any dimension you do provide will be overwritten fully.
}

\section{Removing transformations}{

To remove transformations from a variable or CrunchCube, use
\code{transforms(x) <- NULL}.
}

