% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-insertions.R
\name{addSummaryStat}
\alias{addSummaryStat}
\title{Add summary statistics to a CrunchCube}
\usage{
addSummaryStat(cube, stat = c("mean", "median"), var, ...)
}
\arguments{
\item{cube}{a CrunchCube to add stats to}

\item{stat}{a character with the summary statistic to include (default: "mean")}

\item{var}{a character with the name of the dimension variable to add the
summary statistic for generally the alias of the variable in Crunch, but
might include Crunch functions like \code{rollup()}, \code{bin()}, etc.}

\item{...}{options to pass to \code{SummaryStat()} (e.g., position, after, etc.)}
}
\value{
a CrunchCube with the summary statistic Insertion added to the
transforms of the variable specified
}
\description{
Use \code{addSummaryStat()} to add a summary statistic to a CrunchCube object. If
not otherwise specified, the summary statistic will be \code{mean} and be placed
at the bottom of the cube. You can change those defaults by passing any value
you can use with \code{SummaryStat()} (e.g. \code{position}, \code{categories}, \code{after}).
}
\examples{
\dontrun{
pet_feelings
#                   animals
#feelings            cats dogs
#  extremely happy      9    5
#  somewhat happy      12   12
#  neutral             12    7
#  somewhat unhappy    10   10
#  extremely unhappy   11   12

# add a mean summary statistic to a CrunchCube
addSummaryStat(pet_feelings, stat = "mean", var = "feelings")
#                 animals
#feelings                      cats             dogs
#  extremely happy                9                5
#   somewhat happy               12               12
#          neutral               12                7
# somewhat unhappy               10               10
#extremely unhappy               11               12
#             mean 4.90740740740741 4.34782608695652

# we can also store the CrunchCube for use elsewhere
pet_feelings <- addSummaryStat(pet_feelings, stat = "mean", var = "feelings")
pet_feelings
#                 animals
#feelings                      cats             dogs
#  extremely happy                9                5
#   somewhat happy               12               12
#          neutral               12                7
# somewhat unhappy               10               10
#extremely unhappy               11               12
#             mean 4.90740740740741 4.34782608695652

# `addSummaryStat` returns a CrunchCube that has had the summary statistic
# added to it, so that you can still use the Crunch logic for multiple
# response variables, missingness, etc.
class(pet_feelings)
#[1] "CrunchCube"
#attr(,"package")
#[1] "crunch"

# Since `pet_feelings` is a CrunchCube, although it has similar properties 
# and behaviors to arrays, it is not a R array: 
is.array(pet_feelings)
#[1] FALSE

# cleanup transforms
transforms(pet_feelings) <- NULL
# add a median summary statistic to a CrunchCube
pet_feelings <- addSummaryStat(pet_feelings, stat = "median", var = "feelings")
pet_feelings
#                 animals
#feelings             cats    dogs
#  extremely happy       9       5
#   somewhat happy      12      12
#          neutral      12       7
# somewhat unhappy      10      10
#extremely unhappy      11      12
#           median       5       5

# additionally, if you want a true matrix object from the CrunchCube, rather
# than the CrunchCube object itself, `applyTransforms()` will return the
# array with the summary statistics (just like subtotals and headings)
pet_feelings_array <- applyTransforms(pet_feelings)
pet_feelings_array
#                 animals
#feelings             cats    dogs
#  extremely happy       9       5
#   somewhat happy      12      12
#          neutral      12       7
# somewhat unhappy      10      10
#extremely unhappy      11      12
#           median       5       5

# and we can see that this is an array and no longer a CrunchCube
is.array(pet_feelings_array)
#[1] TRUE
}

}
\seealso{
SummaryStat
}
