% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shoji-order.R
\name{moveToGroup}
\alias{moveToGroup}
\alias{moveToGroup<-}
\title{Move entities to a group}
\usage{
moveToGroup(x, value)

moveToGroup(x) <- value
}
\arguments{
\item{x}{VariableGroup}

\item{value}{Variable, VariableCatalog subset, or Dataset subset}
}
\value{
\code{x} with the entities in \code{value} appended to it. If the
containing order object has \code{duplicates=FALSE}, the entities will be "moved"
to this group. Otherwise, their references will be copied to the group.
}
\description{
Shoji entities can be placed into groups, this is mostly used for grouping
variables for display in the app, but is technically possible for any of the
order catalogs. This function moves an entity to one of these groups.
}
\details{
The function has two versions: a regular function and a setter. They do the
same thing, but the setter is probably more succinct.
}
\examples{
\dontrun{
moveToGroup(ordering(ds)[["Demographics"]]) <- ds[c("gender", "age")]
}
}
