% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crunchbox.R
\name{embedCrunchBox}
\alias{embedCrunchBox}
\title{Get HTML for embedding a CrunchBox}
\usage{
embedCrunchBox(box, title = NULL, logo = NULL, ...)
}
\arguments{
\item{box}{character URL of the box data, as returned by
\code{crunchBox}}

\item{title}{character title for the Box, to appear above the iframe. Default
is \code{NULL}, meaning no title shown}

\item{logo}{character URL of a logo to show instead of a title. Default is
\code{NULL}, meaning no logo shown. If both logo and title are provided, only the
logo will be shown. Note also that logo must be a URL of a hosted image: it
cannot be a path to a local file.}

\item{...}{Additional arguments, not currently used.}
}
\value{
Prints the HTML markup to the screen and also returns it invisibly.
}
\description{
\code{\link[=crunchBox]{crunchBox()}} returns a URL to the box data that it generates, but
in order to view it in a CrunchBox or to embed it on a website, you'll need
to translate that to the Box's public URL and wrap it in some HTML. This function
takes a crunchBox and returns the HTLM which you can embed in a website.
}
\examples{
\dontrun{
box <- crunchBox(ds)
embedCrunchBox(box, logo="//myco.example/img/logo_200px.png")
}
}
\seealso{
\code{\link[=crunchBox]{crunchBox()}}
}
