% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mocking.R
\name{mock}
\alias{mock}
\title{Mocking HTTP requests}
\usage{
mock(on = TRUE)
}
\arguments{
\item{on}{(logical) turn mocking on with \code{TRUE} or turn off with \code{FALSE}.
By default is \code{FALSE}}
}
\description{
Mocking HTTP requests
}
\details{
\code{webmockr} package required for mocking behavior
}
\examples{
\dontrun{

if (interactive()) {
  # load webmockr
  library(webmockr)
  library(crul)

  URL <- "https://hb.opencpu.org"

  # turn on mocking
  crul::mock()

  # stub a request
  stub_request("get", file.path(URL, "get"))
  webmockr:::webmockr_stub_registry

  # create an HTTP client
  (x <- HttpClient$new(url = URL))

  # make a request - matches stub - no real request made
  x$get('get')

  # allow net connect
  webmockr::webmockr_allow_net_connect()
  x$get('get', query = list(foo = "bar"))
  webmockr::webmockr_disable_net_connect()
  x$get('get', query = list(foo = "bar"))
}

}
}
