% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crsra_delete_user.R
\name{crsra_delete_user}
\alias{crsra_delete_user}
\title{Deletes a specific user from all tables in the data in case Coursera data
privacy laws require you to delete a specific (or set of) user(s) from your
data.}
\usage{
crsra_delete_user(all_tables, users)
}
\arguments{
\item{all_tables}{A list from \code{\link{crsra_import_course}} or
\code{\link{crsra_import}}}

\item{users}{A vector of user ids to delete}
}
\value{
A list that contains all the tables within each course.
}
\description{
Deletes a specific user from all tables in the data in case Coursera data
privacy laws require you to delete a specific (or set of) user(s) from your
data.
}
\examples{
del_user = example_course_import$users$jhu_user_id[1]
del_user \%in\% example_course_import$users$jhu_user_id
res = crsra_delete_user(example_course_import, users = del_user)
del_user \%in\% res$users$jhu_user_id

}
