% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crsra_anonymize.R
\name{crsra_anonymize}
\alias{crsra_anonymize}
\title{Anonymizes ID variables (such as Partner hashed user ids) throughout
the data set. The function is based on the function \code{digest} from the
package \code{digest}.}
\usage{
crsra_anonymize(all_tables,
  col_to_mask = attributes(all_tables)$partner_user_id, algorithm = "crc32")
}
\arguments{
\item{all_tables}{A list from \code{\link{crsra_import_course}} or
\code{\link{crsra_import}}}

\item{col_to_mask}{The name of id column to mask.}

\item{algorithm}{The algorithms to be used for anonymization;
for currently available choices, see \code{\link{digest}}.}
}
\value{
A list that contains all the tables within each course.
}
\description{
This function will still keep the relationship between tables, i.e. it will
change a specific id across all tables to the same id.
}
\examples{
res = crsra_anonymize(example_course_import,
col_to_mask = "jhu_user_id",
algorithm = "crc32")
}
