% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{crosstalk_subgraph}
\alias{crosstalk_subgraph}
\title{Helper function to generate subgraph from crosstalk_df output of \code{compute_crosstalk}}
\usage{
crosstalk_subgraph(crosstalk_df, g, seed_proteins)
}
\arguments{
\item{crosstalk_df}{a dataframe containing the results of \code{compute_crosstalk}}

\item{g}{igraph network object.}

\item{seed_proteins}{user defined seed proteins}
}
\value{
a tidygraph structure containing information about the crosstalkr subgraph
}
\description{
Useful if the user wants to carry out further analysis or design custom visualizations.
}
\examples{
\dontrun{
ct_df <- compute_crosstalk(c("EGFR", "KRAS"))
g <- prep_biogrid()
crosstalk_subgraph(ct_df, g = g, seed_proteins = c("EGFR", "KRAS"))
}
}
