% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpluck.R
\name{xpluck}
\alias{xpluck}
\title{Get one or more elements deep within a nested data structure}
\usage{
xpluck(.x, ..., .default = NULL)
}
\arguments{
\item{.x}{A \link{list} or \link{vector}}

\item{...}{A list of accessors for indexing into the object.
Can be positive integers,
negative integers (to index from the right),
strings (to index into names) or
missing (to keep all elements at a given level).

Unlike \code{\link[purrr:pluck]{purrr::pluck()}},
each accessor may be a vector to extract multiple elements.}

\item{.default}{Value to use if target is \code{\link{NULL}} or absent.}
}
\value{
A \link{list} or \link{vector}.
}
\description{
\code{xpluck()} provides an alternative to \code{\link[purrr:pluck]{purrr::pluck()}}.
Unlike \code{\link[purrr:pluck]{purrr::pluck()}}, \code{xpluck()} allows you to extract multiple indices at
each nesting level.
}
\examples{
obj1 <- list("a", list(1, elt = "foo"))
obj2 <- list("b", list(2, elt = "bar"))
x <- list(obj1, obj2)

xpluck(x, 1:2, 2)
xpluck(x, , 2)

xpluck(x, , 2, 1)
xpluck(x, , 2, 2)
xpluck(x, , 2, 1:2)
}
