% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reciprocal_space.R
\name{fluorescent_scan}
\alias{fluorescent_scan}
\title{Find optimal wavelength for anomalous phasing}
\usage{
fluorescent_scan(chem_el, lambda_range = NULL)
}
\arguments{
\item{chem_el}{1- or 2-letters character string. The chemical symbol of
interest.}

\item{lambda_range}{Real vector of length 2. The two values are the extremes of
the wavelength window inside which to carry out the search. Default is
for the search to be carried out across the full available range.}
}
\value{
A named list with two elements: 1) idx is the integer indicating the
   row in the anomalous_data dataframe related to the specific chemical
   element, corresponding to the optimal wavelength; 2) the optimal wavelength
   in angstroms.
}
\description{
This function mimics the behaviour of the fluorescent scan operated at
synchrotron beamlines to find out the optimal wavelength which maximises
the anomalous signal used to phase a structure.
}
\examples{
# Optimal wavelength for iron
lFe <- fluorescent_scan("Fe")
print(lFe$lambda)
idx <- lFe$idx

# Load anomalous dataframe for Fe
adFe <- load_anomalous_data("Fe")
print(adFe[idx,])  # Same wavelength as before!

# Optimal wavelength with window restriction
lFe <- fluorescent_scan("Fe",lambda_range=c(6,8))
print(lFe$lambda)

}
