% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Samples-methods.R
\name{fitGain}
\alias{fitGain}
\alias{fitGain,ModelTox,Samples,ModelEff,Samples,DataDual-method}
\title{Get the fitted values for the gain values at all dose levels based on
a given pseudo DLE model, DLE sample, a pseudo efficacy model, a Efficacy sample
and data. This method returns a data frame with dose, middle, lower and upper quantiles
of the gain value samples}
\usage{
fitGain(DLEmodel, DLEsamples, Effmodel, Effsamples, data, ...)

\S4method{fitGain}{ModelTox,Samples,ModelEff,Samples,DataDual}(
  DLEmodel,
  DLEsamples,
  Effmodel,
  Effsamples,
  data,
  points = data@doseGrid,
  quantiles = c(0.025, 0.975),
  middle = mean,
  ...
)
}
\arguments{
\item{DLEmodel}{the DLE pseudo model of \code{\linkS4class{ModelTox}} class object}

\item{DLEsamples}{the DLE samples of \code{\linkS4class{Samples}} class object}

\item{Effmodel}{the efficacy pseudo model of \code{\linkS4class{ModelEff}} class object}

\item{Effsamples}{the efficacy samples of \code{\linkS4class{Samples}} class object}

\item{data}{the data input of \code{\linkS4class{DataDual}} class object}

\item{\dots}{additional arguments for methods}

\item{points}{at which dose levels is the fit requested? default is the dose
grid}

\item{quantiles}{the quantiles to be calculated (default: 0.025 and
0.975)}

\item{middle}{the function for computing the middle point. Default:
\code{\link{mean}}}
}
\description{
Get the fitted values for the gain values at all dose levels based on
a given pseudo DLE model, DLE sample, a pseudo efficacy model, a Efficacy sample
and data. This method returns a data frame with dose, middle, lower and upper quantiles
of the gain value samples
}
\section{Functions}{
\itemize{
\item \code{fitGain(
  DLEmodel = ModelTox,
  DLEsamples = Samples,
  Effmodel = ModelEff,
  Effsamples = Samples,
  data = DataDual
)}: This method returns a data frame with dose, middle, lower, upper quantiles for
the gain values obtained given the DLE and the efficacy samples

}}
\examples{
##Obtain the 'fitGain' the middle, uppper and lower quantiles for the samples of gain values
## at all dose levels using a pseudo DLE model, a DLE sample, a pseudo Efficacy model and
## a efficacy sample
## data must be from 'DataDual' class
data <- DataDual(
  x = c(25, 50, 25, 50, 75, 300, 250, 150),
  y = c(0, 0, 0, 0, 0, 1, 1, 0),
  w = c(0.31, 0.42, 0.59, 0.45, 0.6, 0.7, 0.6, 0.52),
  doseGrid = seq(25, 300, 25),
  placebo = FALSE
)
## DLE model must be from 'ModelTox' class e.g using 'LogisticIndepBeta' model
DLEmodel <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEweights = c(3, 3),
  DLEdose = c(25, 300),
  data = data
)

## Efficacy model must be from 'ModelEff' class e.g using 'Effloglog' model
Effmodel <- Effloglog(
  c(1.223, 2.513),
  c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = data,
  c = 0
)
## samples must be from 'Samples' class (object slot in fit)
options <- McmcOptions(burnin = 100, step = 2, samples = 200)
##set up the same data set in class 'Data' for MCMC sampling for DLE
data1 <- Data(x = data@x, y = data@y, doseGrid = data@doseGrid)

DLEsamples <- mcmc(data = data1, model = DLEmodel, options = options)
Effsamples <- mcmc(data = data, model = Effmodel, options = options)

fitGain(
  DLEmodel = DLEmodel,
  DLEsamples = DLEsamples,
  Effmodel = Effmodel,
  Effsamples = Effsamples,
  data = data
)
##Obtain the 'fitGain' the middle, uppper and lower quantiles for the samples of gain values
## at all dose levels using a pseudo DLE model, a DLE sample, a pseudo Efficacy model and
## a efficacy sample
## data must be from 'DataDual' class
data <- DataDual(
  x = c(25, 50, 25, 50, 75, 300, 250, 150),
  y = c(0, 0, 0, 0, 0, 1, 1, 0),
  w = c(0.31, 0.42, 0.59, 0.45, 0.6, 0.7, 0.6, 0.52),
  doseGrid = seq(25, 300, 25),
  placebo = FALSE
)
## DLE model must be from 'ModelTox' class e.g using 'LogisticIndepBeta' model
DLEmodel <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEweights = c(3, 3),
  DLEdose = c(25, 300),
  data = data
)

## Efficacy model must be from 'ModelEff' class e.g using 'Effloglog' model
Effmodel <- Effloglog(
  c(1.223, 2.513),
  c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = data,
  c = 0
)
## samples must be from 'Samples' class (object slot in fit)
options <- McmcOptions(burnin = 100, step = 2, samples = 200)
##set up the same data set in class 'Data' for MCMC sampling for DLE
data1 <- Data(x = data@x, y = data@y, doseGrid = data@doseGrid)

DLEsamples <- mcmc(data = data1, model = DLEmodel, options = options)
Effsamples <- mcmc(data = data, model = Effmodel, options = options)

fitGain(
  DLEmodel = DLEmodel,
  DLEsamples = DLEsamples,
  Effmodel = Effmodel,
  Effsamples = Effsamples,
  data = data
)
}
\keyword{methods}
