% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_activity.R
\name{sch_nr_activities}
\alias{sch_nr_activities}
\title{Nr. of Activities}
\usage{
sch_nr_activities(sch)
}
\arguments{
\item{sch}{A schedule object.}
}
\value{
A integer value indicating the number of activities.
}
\description{
Number of activities in a schedule as an integer value.
}
\examples{
sch <- sch_new()
sch_nr_activities(sch) # 0

sch <- sch_new() \%>\%
  sch_add_activity(1L, "Only one", 0L) \%>\%
  sch_plan()
sch_nr_activities(sch) # 1

}
\seealso{
\code{\link[=sch_add_activity]{sch_add_activity()}}, \code{\link[=sch_nr_relations]{sch_nr_relations()}}, \code{\link[=sch_add_activities]{sch_add_activities()}},
\code{\link[=sch_activities]{sch_activities()}}, \code{\link[=sch_change_activities_duration]{sch_change_activities_duration()}},
\code{\link[=sch_critical_activities]{sch_critical_activities()}}, \code{\link[=sch_get_activity]{sch_get_activity()}}, \code{\link[=sch_has_any_relation]{sch_has_any_relation()}}.
}
