% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criticalpath.R
\docType{package}
\name{criticalpath}
\alias{criticalpath}
\title{criticalpath: Object Oriented Critical Path Method Implementation}
\description{
criticalpath package is an object oriented implementation of the
Critical Path Method (CPM) in R with R6 library. CPM is a method used to estimate
the minimum project duration and  determine the amount of scheduling flexibility
on the logical network paths within the schedule model. The flexibility is in
terms of early start, early finish, late start, late finish, total float and
free float. Besides, it permits to quantify the complexity of network diagram
through the analysis of topological indicators. Finally, it permits to change
the activities duration to perform what-if scenario analysis.

With this package, you can calculate the following CPM parameters:
\itemize{
\item Schedule duration
\item Early start and finish date of each activity
\item Late start and finish date of each activity
\item Critical activities
\item Critical path
\item Total float and free float
\item Gantt Matrix
\item What-if scenario analysis
\item Topological indicators
}
}
\references{
Csardi, G. & Nepusz, T. (2005).
The Igraph Software Package for Complex Network Research.
\emph{InterJournal}. Complex Systems. 1695.

Project Management Institute (2017)
\strong{A Guide to the Project Management Body of Knowledge (PMBOK Guide)}.
Sixth Edition.

Project Management Institute (2017)
\strong{PMI Lexicon of Project Management Terms:} Version 3.2.

Vanhoucke, M. (2009) \strong{Measuring Time}:
Improving Project Performance Using Earned Value Management.
Springer-Verlag US.

Vanhoucke, M. (2013) \strong{Project Management with Dynamic Scheduling}:
Baseline Scheduling, Risk Analysis and Project Control.
Springer-Verlag Berlin Heidelberg.

Vanhoucke, M. (2014) \strong{Integrated Project Management and Control}:
First Comes the Theory, then the Practice.
Springer International Publishing Switzerland.
}
\seealso{
On vignette package there are more information with examples about:
\itemize{
\item Schedule Class Definition: \link{Schedule}
\item How to create a schedule:
\itemize{
\item Add activities and relations together to an schedule.
\item Add activities to a schedule.
\item Add relations to a schedule.
\item Create a schedule object from data frames.
}
\item How to get schedule information:
\itemize{
\item Title, Reference and Schedule Duration.
}
\item How to get activities properties:
\itemize{
\item Activity Properties.
\item Gantt Matrix.
}
\item How to change activities duration:
\itemize{
\item Change Activities Duration.
}
\item How to get relations properties:
\itemize{
\item Relation Properties
\item Successors and Predecessors.
}
\item How to get topological properties:
\itemize{
\item Topological Indicators.
}
}
}
\author{
Rubens Jose Rosa (\email{rubens@rubensjoserosa.com}),
Marcos dos Santos (\email{marcosdossantos@ime.eb.br}),
Thiago Marques (\email{profestathimarques@gmail.com})
}
