% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{Risk}
\alias{Risk}
\title{Risk Function}
\usage{
Risk(
  bn,
  code = "mcnp",
  cores = parallel::detectCores()/2,
  dist = "gamma",
  facility.data,
  keff.cutoff = 0.9,
  metamodel,
  risk.pool = 100,
  sample.size = 1e+09,
  usl = 0.95,
  ext.dir
)
}
\arguments{
\item{bn}{Bayesian network}

\item{code}{Monte Carlo radiation transport code (e.g., "cog", "mcnp")}

\item{cores}{Number of CPU cores to use for generating Bayesian network samples}

\item{dist}{Truncated probability distribution (e.g., "gamma", "normal")}

\item{facility.data}{.csv file name}

\item{keff.cutoff}{keff cutoff value (e.g., keff >= 0.9)}

\item{metamodel}{List of deep neural network metamodels and weights}

\item{risk.pool}{Number of times risk is calculated}

\item{sample.size}{Number of samples used to calculate risk}

\item{usl}{Upper subcritical limit (e.g., keff >= 0.95)}

\item{ext.dir}{External directory (full path)}
}
\value{
A list of lists containing process criticality accident risk estimates and Bayesian network samples
}
\description{
This function imports the Sample function and estimates process criticality accident risk.
}
\examples{

ext.dir <- paste0(tempdir(), "/criticality/extdata")
dir.create(ext.dir, recursive = TRUE, showWarnings = FALSE)

extdata <- paste0(.libPaths()[1], "/criticality/extdata")
file.copy(paste0(extdata, "/facility.csv"), ext.dir, recursive = TRUE)
file.copy(paste0(extdata, "/mcnp-dataset.RData"), ext.dir, recursive = TRUE)

config <- FALSE
try(config <- reticulate::py_config()$available)
try(if (config == TRUE) {
  Risk(
    bn = BN(
      facility.data = "facility.csv",
      dist = "gamma",
      ext.dir = ext.dir),
    code = "mcnp",
    cores = 1,
    dist = "gamma",
    facility.data = "facility.csv",
    keff.cutoff = 0.5,
    metamodel = NN(
      batch.size = 128,
      code = "mcnp",
      ensemble.size = 1,
      epochs = 10,
      layers = "8192-256-256-256-256-16",
      loss = "sse",
      opt.alg = "adamax",
      learning.rate = 0.00075,
      val.split = 0.2,
      replot = TRUE,
      verbose = TRUE,
      ext.dir = ext.dir),
    risk.pool = 10,
    sample.size = 1e+04,
    usl = 0.95,
    ext.dir = ext.dir
  )
})

}
