% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{make_average_graph}
\alias{make_average_graph}
\title{Create a line graph with 95\% confidence interval bars}
\usage{
make_average_graph(
  data,
  x_col,
  y_col,
  confidence_interval_error_bars = TRUE,
  mean_line = TRUE,
  type = c("line", "bar")
)
}
\arguments{
\item{data}{A data.frame with the data you want to graph}

\item{x_col}{A string with the name of the x-axis column}

\item{y_col}{A string with the name of the y-axis column}

\item{confidence_interval_error_bars}{A boolean (default TRUE) for whether to include 95\% confidence intervals
or not.}

\item{mean_line}{If TRUE (default) willadd a dashed line with the overall mean.}

\item{type}{A string for whether it should make a linegraph ("line", default) or a bargraph ("bar")}
}
\value{
A ggplot object. Also prints the graph to the Plots panel.
}
\description{
Create a line graph with 95\% confidence interval bars
}
\examples{
data = data.frame(x = sample(15:25, size = 200, replace = TRUE),
y = sample(1:100, size = 200, replace = TRUE))
make_average_graph(data, "x", "y")
make_average_graph(data, "x", "y", confidence_interval_error_bars  = FALSE)
make_average_graph(data, "x", "y", type = "bar", mean_line = FALSE)
make_average_graph(data, "x", "y", confidence_interval_error_bars  = FALSE, type = "bar")
}
