% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{make_stat_count_plots}
\alias{make_stat_count_plots}
\title{Make a nice-looking stat_count (similar to barplot) plot.}
\usage{
make_stat_count_plots(
  data,
  column,
  count = TRUE,
  title = NULL,
  ylab = NULL,
  xlab = NULL
)
}
\arguments{
\item{data}{A data.frame with the data you want to graph.}

\item{column}{A string with the name of the column you want to make the plot from.}

\item{count}{A boolean (default TRUE) indicating if you want the barplot to show a count
of the column values or a percent.}

\item{title}{A string with the text you want as the title.}

\item{ylab}{A string with the text you want as the y-axis label.}

\item{xlab}{A string with the text you want as the x-axis label.}
}
\value{
A stat_count object
}
\description{
Make a nice-looking stat_count (similar to barplot) plot.
}
\examples{
make_stat_count_plots(mtcars, "mpg")

make_stat_count_plots(mtcars, "mpg", count = FALSE, title = "hello", ylab = "YLAB Label")
}
