% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{make_regression_table}
\alias{make_regression_table}
\title{Turns regression results in a data.frame for easy conversion to a table}
\usage{
make_regression_table(model, coefficients_only = TRUE)
}
\arguments{
\item{model}{A `lm` object made from making a model using `lm()`.}

\item{coefficients_only}{If TRUE (default), returns only the coefficients,standard error, t-value,
p-value, and confidence intervals. Else also returns the r-squared,
the adjusted r-squared,f-stat, p-value for the f-stat, and the degrees
of freedom.}
}
\value{
A data.frame with the regression results
}
\description{
Turns regression results in a data.frame for easy conversion to a table
}
\examples{
make_regression_table(lm(mpg ~ cyl, data = mtcars))
make_regression_table(lm(mpg ~ cyl, data = mtcars), coefficients_only = FALSE)
}
