% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTeamData.R
\name{getTeamData}
\alias{getTeamData}
\title{Get the data for a team in a match type  viz.for Test, ODI and T20}
\usage{
getTeamData(dir=".",file="team001.csv",matchType="Test",
        homeOrAway=c(1,2,3),result=c(1,2,3,4),teamView="bat",save=FALSE,teamName)
}
\arguments{
\item{dir}{The directory where the team data CSV file be saved}

\item{file}{The name of the CSV file to save to}

\item{matchType}{The match type - Test, ODI , T20}

\item{homeOrAway}{Whether the data has to be got for home-1, away(overseas)-2 or neutral -3}

\item{result}{The result of the match for which data is to be saved - won-1, lost -2, tied-3, draw-4}

\item{teamView}{This can be 'bat' - batting team or 'bowl' - bowling team}

\item{save}{This can be set as TRUE or FALSE}

\item{teamName}{This is team name}
}
\value{
The required data frame
}
\description{
This function returns team data as a CSV file and/or a dataframe for Test, ODI and T20
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get the team data for India for Tests

df=getTeamData(dir=".",file="australia.csv", matchType="Test",homeOrAway=c(1,2,3),
       result=c(1,2,3, 4),teamView='bat',teamName="Australia")
}
}
\references{
\url{http://www.espncricinfo.com/ci/content/stats/index.html}\cr
\url{https://gigadom.in/}\cr
}
\seealso{
\code{\link{teamWinLossStatusVsOpposition}}
\code{\link{teamWinLossStatusAtGrounds}}
\code{\link{plotTimelineofWinsLosses}}
}
\author{
Tinniam V Ganesh
}
