% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_client.R
\name{crew_client}
\alias{crew_client}
\title{Create a client object.}
\usage{
crew_client(
  name = NULL,
  workers = NULL,
  host = NULL,
  port = NULL,
  tls = crew::crew_tls(),
  tls_enable = NULL,
  tls_config = NULL,
  seconds_interval = 1,
  seconds_timeout = 60,
  retry_tasks = NULL
)
}
\arguments{
\item{name}{Deprecated on 2025-01-14 (\code{crew} version 0.10.2.9002).}

\item{workers}{Deprecated on 2025-01-13 (\code{crew} version 0.10.2.9002).}

\item{host}{IP address of the \code{mirai} client to send and receive tasks.
If \code{NULL}, the host defaults to the local IP address.}

\item{port}{TCP port to listen for the workers. If \code{NULL},
then an available ephemeral port is automatically chosen.
Controllers running simultaneously on the same computer
(as in a controller group) must not share the same TCP port.}

\item{tls}{A TLS configuration object from \code{\link[=crew_tls]{crew_tls()}}.}

\item{tls_enable}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{tls_config}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete,
such as checking \code{mirai::status()}}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{retry_tasks}{Deprecated on 2025-01-13 (\code{crew} version 0.10.2.9002).}
}
\description{
Create an \code{R6} wrapper object to manage the \code{mirai} client.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
client$summary()
client$terminate()
}
}
\seealso{
Other client: 
\code{\link{crew_class_client}}
}
\concept{client}
