% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_router.R
\name{crew_router}
\alias{crew_router}
\title{Create a router.}
\usage{
crew_router(
  name = NULL,
  workers = 1L,
  host = NULL,
  port = 0L,
  seconds_interval = 0.001,
  seconds_timeout = 5,
  seconds_exit = 0.1,
  seconds_poll_high = 0.001,
  seconds_poll_low = 0.01,
  async_dial = TRUE
)
}
\arguments{
\item{name}{Name of the router object. If \code{NULL}, a name is automatically
generated.}

\item{workers}{Integer, maximum number of parallel workers to run.}

\item{host}{IP address of the \code{mirai} client to send and receive tasks.
If \code{NULL}, the host defaults to the local IP address.}

\item{port}{TCP port to listen for the workers. If \code{0},
then NNG automatically chooses an available ephemeral port.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete.}

\item{seconds_exit}{Number of seconds to wait for NNG websockets
to finish sending large data (in case an exit signal is received).}

\item{seconds_poll_high}{High polling interval in seconds for the
\code{mirai} active queue. See the \code{pollfreqh} argument of
\code{mirai::dispatcher()}.}

\item{seconds_poll_low}{Low polling interval in seconds for the \code{mirai}
active queue. See the \code{pollfreql} argument of
\code{mirai::dispatcher()}.}

\item{async_dial}{Logical, whether the \code{mirai} workers should dial in
asynchronously. See the \code{asyncdial} argument of \code{mirai::server()}.}
}
\description{
Create an \code{R6} object to manage the \code{mirai} task scheduler
client.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
router <- crew_router()
router$listen()
router$daemons
router$terminate()
}
}
\seealso{
Other routers: 
\code{\link{crew_class_router}}
}
\concept{routers}
\keyword{internal}
