% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_anaylsis.R
\name{rules_filter}
\alias{rules_filter}
\title{rules_filter}
\usage{
rules_filter(dat, rules_list, drop = FALSE, logic = "or")
}
\arguments{
\item{dat}{A data.frame.}

\item{rules_list}{A list of rules.}

\item{drop}{Logical, if TRUE, dropping samples, if FALSE, selecting samples. Default is FALSE.}

\item{logic}{The logic between rules in the rules_list: 'and','or'. Default is 'or'.}
}
\value{
A data frame with tree rules and percent under each rule.
}
\description{
\code{rules_filter} This function is used to filter or select samples by rules.
}
\examples{
train_test <- train_test_split(UCICreditCard, split_type = "Random", prop = 0.8, save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
dat_train$default.payment.next.month = as.numeric(dat_train$default.payment.next.month)
rules_list = get_ctree_rules(tree_fit = NULL, train_dat = dat_train[, 8:26],
                             target ="default.payment.next.month", test_dat = dat_test)[1:3,2]
 new_dat = rules_filter(rules_list = rules_list[3], dat = dat_test)

}
\seealso{
\code{\link{get_ctree_rules}},
\code{\link{check_rules}}
}
