% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{lr_params}
\alias{lr_params}
\alias{lr_params_search}
\title{Logistic Regression & Scorecard Parameters}
\usage{
lr_params(
  tree_control = list(p = 0.02, cp = 0.00000001, xval = 5, maxdepth = 10),
  bins_control = list(bins_num = 10, bins_pct = 0.05, b_chi = 0.02, b_odds = 0.1, b_psi
    = 0.03, b_or = 0.15, mono = 0.2, odds_psi = 0.15, kc = 1),
  f_eval = "ks",
  best_lambda = "lambda.ks",
  method = "random_search",
  iters = 10,
  lasso = TRUE,
  step_wise = TRUE,
  score_card = TRUE,
  sp_values = NULL,
  forced_in = NULL,
  obsweight = c(1, 1),
  thresholds = list(cor_p = 0.8, iv_i = 0.02, psi_i = 0.1, cos_i = 0.5),
  ...
)

lr_params_search(
  method = "random_search",
  dat_train,
  target,
  dat_test = NULL,
  occur_time = NULL,
  x_list = NULL,
  prop = 0.7,
  iters = 10,
  tree_control = list(p = 0.02, cp = 0, xval = 1, maxdepth = 10),
  bins_control = list(bins_num = 10, bins_pct = 0.02, b_chi = 0.02, b_odds = 0.1, b_psi
    = 0.05, b_or = 0.1, mono = 0.1, odds_psi = 0.03, kc = 1),
  thresholds = list(cor_p = 0.8, iv_i = 0.02, psi_i = 0.1, cos_i = 0.6),
  step_wise = FALSE,
  lasso = FALSE,
  f_eval = "ks"
)
}
\arguments{
\item{tree_control}{the list of parameters to control cutting initial breaks by decision tree. See details at: \code{\link{get_tree_breaks}}}

\item{bins_control}{the list of parameters to control merging initial breaks. See details at: \code{\link{select_best_breaks}},\code{\link{select_best_class}}}

\item{f_eval}{Custimized evaluation function, "ks" & "auc" are available.}

\item{best_lambda}{Metheds of best lanmbda stardards using to filter variables by LASSO. There are 3 methods: ("lambda.auc", "lambda.ks", "lambda.sim_sign") . Default is  "lambda.auc".}

\item{method}{Method of searching optimal parameters. "random_search","grid_search","local_search" are available.}

\item{iters}{Number of iterations of "random_search" optimal parameters.}

\item{lasso}{Logical, if TRUE, variables filtering by LASSO. Default is TRUE.}

\item{step_wise}{Logical, stepwise method. Default is TRUE.}

\item{score_card}{Logical, transfer woe to a standard scorecard. If TRUE, Output scorecard, and score prediction, otherwise output probability. Default is TRUE.}

\item{sp_values}{Vaules will be in separate bins.e.g. list(-1, "missing")  means that -1 & missing as special values.Default is NULL.}

\item{forced_in}{Names of forced input variables. Default is NULL.}

\item{obsweight}{An optional vector of 'prior weights' to be used in the fitting process. Should be NULL or a numeric vector. If you oversample or cluster diffrent datasets to training the LR model, you need to set this parameter to ensure that the probability of logistic regression output is the same as that before oversampling or segmentation. e.g.:There are 10,000 0 obs and 500 1 obs before oversampling or under-sampling, 5,000 0 obs and 3,000 1 obs after oversampling. Then this parameter should be set to c(10000/5000, 500/3000). Default is NULL..}

\item{thresholds}{Thresholds for selecting variables.
\itemize{
  \item \code{cor_p} The maximum threshold of correlation. Default: 0.8.
  \item \code{iv_i} The minimum threshold of IV. 0.01 to 0.1 usually work. Default: 0.02
  \item \code{psi_i} The maximum threshold of PSI. 0.1 to 0.3 usually work. Default: 0.1.
  \item \code{cos_i} cos_similarity of posive rate of train and test. 0.7 to 0.9 usually work.Default: 0.5.
}}

\item{...}{Other parameters}

\item{dat_train}{data.frame of train data. Default is NULL.}

\item{target}{name of target variable.}

\item{dat_test}{data.frame of test data. Default is NULL.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.Default is NULL.}

\item{x_list}{names of independent variables. Default is NULL.}

\item{prop}{Percentage of train-data after the partition. Default: 0.7.}
}
\value{
A list of parameters.
}
\description{
\code{lr_params} is the list of parameters to train a LR model or Scorecard using in  \code{\link{training_model}}.
\code{lr_params_search} is for searching the optimal parameters of logistic regression,if any parameters of params in \code{\link{lr_params}} is more than one.
}
\seealso{
\code{\link{training_model}}, \code{\link{xgb_params}}, \code{\link{gbm_params}}, \code{\link{rf_params}}
}
