% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{cor_heat_plot}
\alias{cor_heat_plot}
\title{Correlation Heat Plot}
\usage{
cor_heat_plot(
  cor_mat,
  low_color = love_color("deep_red"),
  high_color = love_color("light_cyan"),
  title = "Correlation Matrix"
)
}
\arguments{
\item{cor_mat}{A correlation matrix.}

\item{low_color}{color of the lowest correlation between variables.}

\item{high_color}{color of the highest correlation between variables.}

\item{title}{title of plot.}
}
\description{
\code{cor_heat_plot} is for ploting correlation matrix
}
\examples{
train_test <- train_test_split(UCICreditCard,
split_type = "Random", prop = 0.8,save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
cor_mat = cor(dat_train[,8:12],use = "complete.obs")
cor_heat_plot(cor_mat)
}
