% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_binning.R
\name{cut_equal}
\alias{cut_equal}
\title{Generating Initial Equal Size Sample Bins}
\usage{
cut_equal(dat_x, g = 10, sp_values = NULL, cut_bin = "equal_depth")
}
\arguments{
\item{dat_x}{A vector of an variable x.}

\item{g}{numeric, number of initial bins for equal_bins.}

\item{sp_values}{a list of special value. Default: list(-1, "missing")}

\item{cut_bin}{A string, 'equal_depth' or 'equal_width', default is 'equal_depth'.}
}
\description{
\code{cut_equal} is used to generate initial breaks for equal frequency binning.
}
\examples{
#equal sample size breaks
equ_breaks = cut_equal(dat = UCICreditCard[, "PAY_AMT2"], g = 10)

}
\seealso{
\code{\link{get_breaks}}, \code{\link{get_breaks_all}},\code{\link{get_tree_breaks}}
}
