% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{lr_params}
\alias{lr_params}
\title{Logistic Regression & Scorecard Parameters}
\usage{
lr_params(tree_control = list(p = 0.02, cp = 1e-08, xval = 5, maxdepth =
  10), bins_control = list(bins_num = 10, bins_pct = 0.05, b_chi = 0.02,
  b_odds = 0.1, b_psi = 0.03, b_or = 0.15, mono = 0.2, odds_psi = 0.15, kc
  = 1), best_lambda = "lambda.sim_sign", sp_values = NULL,
  forced_in = NULL, obsweight = c(1, 1), lasso = TRUE,
  vars_plot = TRUE, step_wise = TRUE, score_card = TRUE,
  cor_p = 0.8, iv_i = 0.02, psi_i = 0.1, ...)
}
\arguments{
\item{tree_control}{the list of parameters to control cutting initial breaks by decision tree. See details at: \code{\link{get_tree_breaks}}}

\item{bins_control}{the list of parameters to control merging initial breaks. See details at: \code{\link{select_best_breaks}},\code{\link{select_best_class}}}

\item{best_lambda}{Metheds of best lanmbda stardards using to filter variables by LASSO. There are 3 methods: ("lambda.auc", "lambda.ks", "lambda.sim_sign") . Default is  "lambda.auc".}

\item{sp_values}{Vaules will be in separate bins.e.g. list(-1, "Missing")  means that -1 & Missing as special values.Default is NULL.}

\item{forced_in}{Names of forced input variables. Default is NULL.}

\item{obsweight}{An optional vector of  'prior weights' to be used in the fitting process. Should be NULL or a numeric vector. If you oversample or cluster diffrent datasets to training the LR model, you need to set this parameter to ensure that the probability of logistic regression output is the same as that before oversampling or segmentation. e.g.:There are 10,000 0 obs and 500 1 obs before oversampling or under-sampling, 5,000 0 obs and 3,000 1 obs after oversampling. Then this parameter should be set to c(10000/5000, 500/3000). Default is NULL..}

\item{lasso}{Logical, if TRUE, variables filtering by LASSO. Default is TRUE.}

\item{vars_plot}{Logical, if TRUE, plot distribution and correlation of input variables . Default is TRUE.}

\item{step_wise}{Logical, stepwise method. Default is TRUE.}

\item{score_card}{Logical, transfer woe to a standard scorecard. If TRUE, Output scorecard, and score prediction, otherwise output probability. Default is TRUE.}

\item{cor_p}{The maximum threshold of correlation. Default: 0.8.}

\item{iv_i}{The minimum threshold of IV. 0.01 to 0.1 usually work. Default: 0.02}

\item{psi_i}{The maximum threshold of PSI. 0.1 to 0.3 usually work. Default: 0.1.}

\item{...}{Other parameters}
}
\value{
A list of parameters.
}
\description{
\code{lr_params} is the list of parameters to train a LR model or Scorecard using in  \code{\link{training_model}}.
}
\seealso{
\code{\link{training_model}}, \code{\link{xgb_params}}, \code{\link{gbm_params}}, \code{\link{rf_params}}
}
