% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tools.R
\name{get_plots}
\alias{get_plots}
\alias{plot_vars}
\title{Plot Independent Variables}
\usage{
get_plots(dat_train, dat_test = NULL, x_list = NULL, target = NULL,
  ex_cols = NULL, breaks_list = NULL, pos_flag = NULL,
  occur_time = NULL, equal_bins = FALSE, best = TRUE, g = 20,
  tree_control = NULL, bins_control = NULL, plot_show = TRUE,
  save_data = TRUE, file_name = NULL, parallel = FALSE,
  g_width = 8, dir_path = tempdir())

plot_vars(dat_train, x, dat_test = NULL, target = "target",
  g_width = 8, breaks_list = NULL, pos_flag = list("1", 1, "bad",
  "positive"), occur_time = NULL, equal_bins = FALSE, best = TRUE,
  g = 20, tree_control = NULL, bins_control = NULL,
  plot_show = TRUE, save_data = FALSE, dir_path = tempdir())
}
\arguments{
\item{dat_train}{A data.frame with independent variables and target variable.}

\item{dat_test}{A data.frame of test data. Default is NULL.}

\item{x_list}{Names of independent variables.}

\item{target}{The name of target variable.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{pos_flag}{Value of positive class, Default is "1".}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.}

\item{equal_bins}{Logical, generates initial breaks for equal frequency binning.}

\item{best}{Logical, merge initial breaks to get optimal breaks for binning.}

\item{g}{Number of initial breakpoints for equal frequency binning.}

\item{tree_control}{Parameters of using Decision Tree to segment initial breaks. See detials: \code{\link{get_tree_breaks}}}

\item{bins_control}{Parameters  used to control binning.  See detials: \code{\link{select_best_class}}, \code{\link{select_best_breaks}}}

\item{plot_show}{Logical, show model performance in current graphic device. Default is FALSE.}

\item{save_data}{Logical, save results in locally specified folder. Default is TRUE}

\item{file_name}{The name for periodically saved data file. Default is NULL.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{g_width}{The width of graphs.}

\item{dir_path}{The path for periodically saved graphic files.}

\item{x}{The name of an independent variable.}
}
\description{
\code{plot_vars} is used for independent variables with target variable ploting.
\code{get_plots} can loop through plots for all specified independent variables.
}
\examples{
train_test <- train_test_split(UCICreditCard[1:1000,], split_type = "Random",
 prop = 0.8, save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
get_plots(dat_train[, c(8, 26)], dat_test = dat_test[, c(8, 26)],
target = "default.payment.next.month")
}
