% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dupp}
\alias{dupp}
\title{Probability mass function (PMF) of discrete power law}
\usage{
dupp(x, u, xi1, log = FALSE)
}
\arguments{
\item{x}{Vector of positive integers}

\item{u}{Scalar, non-negative integer threshold}

\item{xi1}{Scalar, a positive real number representing the shape parameter}

\item{log}{Boolean (default 'FALSE'), whether the PMF should be returned on the log scale.}
}
\value{
A numeric vector of the same length as x
}
\description{
\code{dupp} returns the PMF at x for the discrete power law with exponent (1.0 / xi1 + 1.0), for values greater than or equal to u.
}
\details{
The PMF is proportional to x^(-alpha), where alpha = 1.0 / xi1 + 1.0. To be a proper PMF, it is normalised by 1/hzeta(alpha, u), where hzeta is the Hurwitz zeta function i.e. hzeta(y, z) = z^(-y) + (z+1)^(-y) + (z+2)^(-y) + ... Any values below u will have PMF equal to 0.0. That xi1 is used instead of alpha is for alignment with the parametrisation in \code{dmix}, \code{Smix} and \code{mcmc_mix}.
}
\examples{
dupp(c(10,20,30,40,50), 12, 2.0, FALSE)
dupp(c(10,20,30,40,50), 12, 2.0, TRUE)
}
\seealso{
\code{\link{Supp}} for the corresponding survival function, \code{\link{dmix}} for the PMF of the discrete extreme value mixture distribution.
}
